﻿using System;
using System.Configuration;
using System.Data;
using System.Web.UI.WebControls;
using VeteransAffairs.Registries.Business;
using VeteransAffairs.Registries.BusinessManager.EFR;

public partial class ReportDoDFragment : BasePage
{

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!AccessAllowed())
        {
            Response.Redirect("ErrorPage.aspx?id=100");
        }

        if (!IsPostBack)
        {
            Session["ReportDoDFragment.sortColumn"] = SessionItemFactory.Create("CREATED");
            Session["ReportDoDFragment.sortOrder"] = SessionItemFactory.Create("Descending");

            // Bind our data
            try
            {
                GridViewDoDFragmentFiles.DataSource = GetDoDFragmentFiles();
                GridViewDoDFragmentFiles.DataBind();

                // Show/hide counts per setting
                if (ConfigurationManager.AppSettings["DoDFragmentReport_ShowCounts"].ToString().Trim() != "true")
                {
                    GridViewDoDFragmentFiles.Columns[3].Visible = false;
                    GridViewDoDFragmentFiles.Columns[4].Visible = false;
                }
            }
            catch (Exception exc)
            {
                Logging.WriteLogToFile("Error processing new referral", exc);
            }

            HiddenFieldClearFlag.Value = "0";
        }
    }

    protected void DoDFragment_RowDataBound(object sender, GridViewRowEventArgs e)
    {
    }

    public void DoDFragment_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (e.CommandName == "Details")
        {
            int index = Convert.ToInt32(e.CommandArgument);
            GridViewDoDFragmentFiles.SelectedIndex = index;
            int id = Convert.ToInt32(GridViewDoDFragmentFiles.SelectedValue);

            DoDFragmentManager manager = new DoDFragmentManager();
            DOD_FRAGMENT_RAW_DATA file = manager.SelectByRawDataId(id);

            Response.ContentType = "application/x-unknown";
            Response.AppendHeader("Content-Disposition", "attachment; filename=\"" + file.ORIGINAL_NAME + "\"");
            Response.BinaryWrite((byte[])file.FILE_DATA.ToArray());
        }
    }

    protected void ButtonClear_Click(object sender, EventArgs e)
    {
        TextBoxSearchCriteria.Text = String.Empty;
        HiddenFieldClearFlag.Value = "1";

        GridViewDoDFragmentFiles.DataSource = GetDoDFragmentFiles();
        GridViewDoDFragmentFiles.DataBind();
    }

    protected void ButtonOK_Click(object sender, EventArgs e)
    {
        GridViewDoDFragmentFiles.PageIndex = 0;
        HiddenFieldClearFlag.Value = "0";

        GridViewDoDFragmentFiles.DataSource = GetDoDFragmentFiles();
        GridViewDoDFragmentFiles.DataBind();
    }

    private bool AccessAllowed()
    {
        return true;
    }
    public override string TopMenuName()
    {
        return "Reporting";
    }

    public override string MenuItemName()
    {
        return "Referral Report";
    }

    public override string AppObjectCode()
    {
        return "EFR_DODFRAGMENT_REPORT";
    }

    public DataTable GetDoDFragmentFiles()
    {
        DataTable dataTable = new DataTable();

        var sortOrder = SessionItemValue.Get(Session["ReportDoDFragment.sortOrder"]);
        var sortColumn = SessionItemValue.Get(Session["ReportDoDFragment.sortColumn"]).ToString();

        dataTable = SqlProvider.ExecuteSPDataTable(
            "RegistryConnectionString", 
            "dbo.usp_EFR_GetDoDFragmentFiles",
            new object[] {
                sortColumn,
                sortOrder,
                TextBoxSearchCriteria.Text.Trim()
                });   

        return dataTable;
    }

    protected void DoDFragment_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    {

    }

    protected void DoDFragment_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridViewDoDFragmentFiles.DataSource = GetDoDFragmentFiles();
        GridViewDoDFragmentFiles.PageIndex = e.NewPageIndex;
        GridViewDoDFragmentFiles.DataBind();
    }

    protected void GridViewDoDFragmentFiles_Sorting(object sender, GridViewSortEventArgs e)
    {
        // Sort order is always Ascending ... deal with this
        var sortOrder = SessionItemValue.Get(Session["ReportDoDFragment.sortOrder"]);
        var sortColumn = SessionItemValue.Get(Session["ReportDoDFragment.sortColumn"]);

        if (sortColumn == e.SortExpression && sortOrder == e.SortDirection.ToString())
        {
            if (sortOrder == "Ascending")
                Session["ReportDoDFragment.sortOrder"] = SessionItemFactory.Create("Descending");
            else
                Session["ReportDoDFragment.sortOrder"] = SessionItemFactory.Create("Ascending");
        }
        else
        {
            Session["ReportDoDFragment.sortOrder"] = SessionItemFactory.Create(e.SortDirection.ToString());
            Session["ReportDoDFragment.sortColumn"] = SessionItemFactory.Create(e.SortExpression.ToString());
        }

        GridViewDoDFragmentFiles.DataSource = GetDoDFragmentFiles();
        GridViewDoDFragmentFiles.PageIndex = 0;
        GridViewDoDFragmentFiles.DataBind();
    }
}
